from flask import Flask, render_template, flash, redirect, session, abort
from flask_sqlalchemy import SQLAlchemy
from flask_wtf import FlaskForm
from wtforms.ext.sqlalchemy.orm import model_form
from wtforms import StringField, PasswordField, validators, BooleanField
from werkzeug.security import generate_password_hash, check_password_hash
from datetime import datetime
from datetime import date

app = Flask(__name__)
db = SQLAlchemy(app)
app.secret_key="ra9ialoH3peNisai5sie8phei2gier7E"

class Task(db.Model):
	id = db.Column(db.Integer, primary_key=True)
	text = db.Column(db.String, nullable=False)

class Day(db.Model):
	id = db.Column(db.Integer, primary_key=True)
	date = db.Column(db.DateTime, nullable=False, unique=True, default=date.today)

class User(db.Model):
	id = db.Column(db.Integer, primary_key=True)
	email = db.Column(db.String, nullable=False)
	passwordHash = db.Column(db.String, nullable=True)

	def setPassword(self, password):
		self.passwordHash = generate_password_hash(password)

	def checkPassword(self, password):
		return check_password_hash(self.passwordHash, password)

TaskForm = model_form(model=Task, base_class=FlaskForm, db_session=db.session)

class UserForm(FlaskForm):
	email = StringField("email", validators=[validators.Email()])
	password = PasswordField("password",
	validators=[validators.InputRequired()])

class Tudayform(FlaskForm):
	yes = BooleanField()

class RegisterForm(UserForm):
	key = StringField("registration key", validators=[validators.InputRequired()])
	email = StringField("email", validators=[validators.Email()])

@app.before_first_request
def tasks():
	db.create_all()

	task = Task(text="go exersise")
	db.session.add(task)

	user = User(email="wall@potato.dog")
	user.setPassword("cat")
	db.session.add(user)

#	categorpub_date = db.Column(db.DateTime, nullable=False,
#        default=datetime.utcnow)y_id = db.Column(db.Integer, db.ForeignKey('category.id'),
#		nullable=False)
#	category = db.relationship('Category',
#		backref=db.backref('posts', lazy=True))

	db.session.commit()

@app.route("/<int:id>/edit", methods=["GET", "POST"])
@app.route("/new", methods=["GET", "POST"])
def lomake(id=None):
	loginRequired()
	task = Task()
	if id:
		task = Task.query.get_or_404(id)
	form = TaskForm(obj=task)
	if form.validate_on_submit():
		form.populate_obj(task)
		db.session.add(task)
		db.session.commit()
		flash("Added")
		return redirect("/")
		print("Added your task, thanks.")
	return render_template("new.html", form=form)

@app.route("/<int:id>/delete")
def deleteTask(id):
	loginRequired()
	task = Task.query.get_or_404(id)
	db.session.delete(task)
	db.session.commit()
	flash("Deleted.")
	return redirect("/")

@app.route("/", methods=["GET", "POST"])
def index():
	loginRequired()
	form = Tudayform()
	if form.validate_on_submit():
		if Day.query.filter_by(date=date.today()).first():
			flash("just relax dude")
			return redirect("/")
		yes = form.yes.data
		print(yes)
		if yes:
			day = Day()
			db.session.add(day)
			try:
				db.session.commit()
			except:
				flash("You alredy compleated your goals today.")
			flash("Added")
			return redirect("/")
	tasks = Task.query.all()
	days = Day.query.all()
	return render_template("index.html", tasks=tasks, form=form, days=days)

@app.errorhandler(403)
def custom403(e):
	return redirect("/login")

def currentUser():
	try:
		uid = int(session["uid"])
	except:
		return None

	return User.query.get(uid)

app.jinja_env.globals["currentUser"] = currentUser

#def past():


def loginRequired():
	print("loginRequired")
	if not currentUser():
		abort(403)

@app.route("/login", methods=["GET", "POST"])
def loginView():
	form = UserForm()
	if form.validate_on_submit():
		email = form.email.data
		password = form.password.data
		user = User.query.filter_by(email=email).first()

		if not user:
			flash("Bad username or password.")
			print("No such user")
			return redirect("/login")

		if not user.checkPassword(password):
			flash("Bad username or password.")
			print("Bad password")
			return redirect("/login")
		flash("Logged in. Welcome!")
		session["uid"]=user.id
		return redirect("/")

	return render_template("new.html", form=form)

@app.route("/logout", methods=["GET", "POST"])
def logoutView():
	session["uid"]=None
	flash("Logged out. Bye bye!")
	return redirect("/")

@app.route("/register", methods=["GET", "POST"])
def registerView():
	form = RegisterForm()
	if form.validate_on_submit():
		if form.key.data != "peruna":
			flash("Bad registration key.")
			return redirect("/register")
		user = User()
		user.email = form.email.data
		user.setPassword(form.password.data)
		db.session.add(user)
		db.session.commit()
		flash("User created. Now, log in!")
		return redirect("/login")
	return render_template("new.html", form=form)

if __name__ == "__main__":
        app.run()
